<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('category_id', 'name', 'item_code', 'sku', 'banner_image', 'thum_panel_image', 'hover_image', 'description', 'add_image', 'related_product', 'price', 'rate_id');

    public function questions()
    {
        return $this->hasMany('App\Models\Question');
    }

    public function howToUses()
    {
        return $this->hasMany('App\Models\HOWTOUse');
    }

    public function features()
    {
        return $this->hasMany('App\Models\Feature');
    }

    public function inventories()
    {
        return $this->belongsToMany('App\Models\Inventory', 'inventory_id');
    }

    public function offer()
    {
        return $this->belongsTo('App\Models\Offer', 'offer_id');
    }

    public function categories()
    {
        return $this->hasMany('App\Models\Category');
    }

    public function colors()
    {
        return $this->hasMany('App\Models\Color');
    }

    public function comments()
    {
        return $this->hasMany('App\Models\Comment');
    }

    public function staffs()
    {
        return $this->belongsToMany('App\Models\Staff', 'staff_id');
    }

    public function rate()
    {
        return $this->hasOne('App\Models\Rate', 'rate_id');
    }

    public function videoes()
    {
        return $this->morphMany('app\Models\Video', 'videoable');
    }

}